'Script to set G92 Machining Coordinates

dim Xpos as double
dim Ypos as double
dim Zpos as double

Xpos = 0
Ypos = 0
Zpos = 0

NCEdit Output, Line = i

Ask Header="G92 Work Coordinates Change",Output, Cancel=canc, "X Position;0"=Xpos, "Y Position;0"=Ypos, "Z Position (leave at 0 for none);0"=Zpos
If canc Then
	Exit
End If


' If all coords are 0, then the user is resetting. Chances are they don't want 
' "G92 X0 Y0 Z0" in their code, so it doesn't output it.
If Xpos = 0 Then
	If Ypos = 0 Then
		If Xpos = 0 Then
			AxisMove X = Xpos, Y = Ypos, Z = Zpos, Absolute = TRUE
			Exit
		End If
	End If
End If


' Gimme code
NCEdit Line = i, Output, Text=txt
txt = txt+"G92"+" X"+Xpos+" Y"+Ypos
If Zpos > 0 Then
	txt = txt+" Z"+Zpos
End If
NCEdit Line = i,Text=txt, Output, NumLines=nl
NCEdit Line = nl+2


' Move to where the nice user told you.
AxisMove X = Xpos * 25.4, Y = Ypos * 25.4, Z = Zpos * 25.4, Absolute = TRUE

NCRenumber

Window2
